/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import rikka.lanserverproperties.IShareToLanScreenParamAccessor;
import rikka.lanserverproperties.OpenToLanScreenEx;

@Mod(value="lanserverproperties")
public class LanServerProperties {
    public static final String MODID = "lanserverproperties";
    public static LanServerProperties INSTANCE = null;

    public LanServerProperties() {
        if (INSTANCE != null) {
            throw new RuntimeException("Duplicated Class Instantiation: CustomItems");
        }
        INSTANCE = this;
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientHandler::registerGuiEventHandler);
    }

    public static OpenToLanScreenEx attachLSPData(ShareToLanScreen screen) {
        return new OpenToLanScreenEx(screen, new ForgeSTLParamAccessor(screen));
    }

    private static OpenToLanScreenEx getLSPData(ShareToLanScreen screen) {
        throw new RuntimeException("Coremod implementation failed!");
    }

    private static class ForgeSTLParamAccessor
    implements IShareToLanScreenParamAccessor {
        private final ShareToLanScreen gui;

        private ForgeSTLParamAccessor(ShareToLanScreen gui) {
            this.gui = gui;
        }

        @Override
        public Screen getLastScreen() {
            return this.gui.f_96643_;
        }

        @Override
        public GameType getGameType() {
            return this.gui.f_169427_;
        }

        @Override
        public boolean isCommandEnabled() {
            return this.gui.f_96647_;
        }

        @Override
        public void setDefault(GameType gameType, boolean commandEnabled) {
            this.gui.f_169427_ = gameType;
            this.gui.f_96647_ = commandEnabled;
        }

        @Override
        public void setMaxPlayer(int num) {
            PlayerList playerList = Minecraft.m_91087_().m_91092_().m_6846_();
            playerList.f_11193_ = num;
        }
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void registerGuiEventHandler() {
            MinecraftForge.EVENT_BUS.addListener(ClientHandler::onGuiPostInit);
            MinecraftForge.EVENT_BUS.addListener(ClientHandler::onGuiDraw);
        }

        public static void onGuiPostInit(ScreenEvent.InitScreenEvent.Post event) {
            Screen gui = event.getScreen();
            if (gui instanceof ShareToLanScreen) {
                OpenToLanScreenEx hook = LanServerProperties.getLSPData((ShareToLanScreen)gui);
                hook.postInitShareToLanScreen(gui.f_96547_, event.getListenersList(), arg_0 -> ((ScreenEvent.InitScreenEvent.Post)event).addListener(arg_0), arg_0 -> ((ScreenEvent.InitScreenEvent.Post)event).removeListener(arg_0));
            } else if (gui instanceof PauseScreen) {
                OpenToLanScreenEx.initPauseScreen(gui, event.getListenersList());
            }
        }

        public static void onGuiDraw(ScreenEvent.DrawScreenEvent.Post event) {
            Screen gui = event.getScreen();
            if (!(gui instanceof ShareToLanScreen)) {
                return;
            }
            OpenToLanScreenEx.postDraw(gui, gui.f_96547_, event.getPoseStack(), event.getMouseX(), event.getMouseY(), event.getPartialTicks());
        }
    }
}

