/*
 * Decompiled with CFR 0.152.
 */
package rikka.lanserverproperties;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class IntegerEditBox
extends EditBox
implements TooltipAccessor {
    private final Function<IntegerEditBox, List<FormattedCharSequence>> toolTipSupplier;
    private boolean contentValid;

    public IntegerEditBox(Font textRenderer, int x, int y, int width, int height, Component name, int defaultVal, Consumer<IntegerEditBox> onChanged, Function<String, Boolean> validator, Function<IntegerEditBox, List<FormattedCharSequence>> toolTipSupplier) {
        super(textRenderer, x, y, width, height, name);
        this.toolTipSupplier = toolTipSupplier == null ? dummy -> ImmutableList.of() : toolTipSupplier;
        this.m_94144_(String.valueOf(defaultVal));
        this.m_94151_(text -> {
            this.contentValid = (Boolean)validator.apply((String)text);
            this.m_94202_(this.contentValid ? 0xFFFFFF : 0xFF0000);
            onChanged.accept(this);
        });
        this.contentValid = validator.apply(this.m_94155_());
    }

    public int getValueAsInt() {
        return Integer.parseInt(this.m_94155_());
    }

    public boolean isContentValid() {
        return this.contentValid;
    }

    public static Function<String, Boolean> makeValidator(int min, int max) {
        return text -> {
            boolean valid = true;
            try {
                if (text.length() > 0) {
                    int port = Integer.parseInt(text);
                    if (port < min || port > max) {
                        valid = false;
                    }
                } else {
                    valid = false;
                }
            }
            catch (NumberFormatException e) {
                valid = false;
            }
            return valid;
        };
    }

    public List<FormattedCharSequence> m_141932_() {
        List<FormattedCharSequence> ret = this.toolTipSupplier.apply(this);
        return ret == null ? ImmutableList.of() : ret;
    }
}

