/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.util;

import com.eerussianguy.firmalife.common.FLHelpers;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;

public enum FLArmorMaterials implements ArmorMaterial
{
    BEEKEEPER(5, 1, 2, 3, 1, 0.0f, 0.0f, 0.0f, 0.0f, 3.0f);

    private final ResourceLocation serializedName = FLHelpers.identifier(this.name().toLowerCase(Locale.ROOT));
    private final int feetDamage;
    private final int legDamage;
    private final int chestDamage;
    private final int headDamage;
    private final int feetReduction;
    private final int legReduction;
    private final int chestReduction;
    private final int headReduction;
    private final float toughness;
    private final float knockbackResistance;
    private final float crushingModifier;
    private final float piercingModifier;
    private final float slashingModifier;

    private FLArmorMaterials(int armor, int feetReduction, int legReduction, int chestReduction, int headReduction, float toughness, float knockbackResistance, float crushingModifier, float piercingModifier, float slashingModifier) {
        this.feetDamage = 13 * armor;
        this.legDamage = 15 * armor;
        this.chestDamage = 16 * armor;
        this.headDamage = 11 * armor;
        this.feetReduction = feetReduction;
        this.legReduction = legReduction;
        this.chestReduction = chestReduction;
        this.headReduction = headReduction;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.crushingModifier = crushingModifier * 0.25f;
        this.piercingModifier = piercingModifier * 0.25f;
        this.slashingModifier = slashingModifier * 0.25f;
    }

    public float crushing() {
        return this.crushingModifier;
    }

    public float piercing() {
        return this.piercingModifier;
    }

    public float slashing() {
        return this.slashingModifier;
    }

    public int m_7366_(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.FEET -> this.feetDamage;
            case EquipmentSlot.LEGS -> this.legDamage;
            case EquipmentSlot.CHEST -> this.chestDamage;
            case EquipmentSlot.HEAD -> this.headDamage;
            default -> 0;
        };
    }

    public int m_7365_(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.FEET -> this.feetReduction;
            case EquipmentSlot.LEGS -> this.legReduction;
            case EquipmentSlot.CHEST -> this.chestReduction;
            case EquipmentSlot.HEAD -> this.headReduction;
            default -> 0;
        };
    }

    public int m_6646_() {
        return 0;
    }

    public SoundEvent m_7344_() {
        return SoundEvents.f_11678_;
    }

    public ResourceLocation getId() {
        return this.serializedName;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public Ingredient m_6230_() {
        return Ingredient.f_43901_;
    }

    public String m_6082_() {
        return this.serializedName.toString();
    }
}

