/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.recipes.data;

import com.eerussianguy.firmalife.common.recipes.data.ContainerAwareModifier;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.FoodHandler;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.recipes.outputs.ItemStackModifier;
import net.minecraft.world.inventory.CraftingContainer;

public interface CustomFoodModifier<T extends ItemStackModifier>
extends ContainerAwareModifier<T> {
    public static final int G = Nutrient.GRAIN.ordinal();
    public static final int F = Nutrient.FRUIT.ordinal();
    public static final int V = Nutrient.VEGETABLES.ordinal();
    public static final int P = Nutrient.PROTEIN.ordinal();
    public static final int D = Nutrient.DAIRY.ordinal();

    default public List<FoodData> gatherIngredients(CraftingContainer inv, FoodHandler.Dynamic dynamic) {
        ArrayList<FoodData> ingredients = new ArrayList<FoodData>(5);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            inv.m_8020_(i).getCapability(FoodCapability.CAPABILITY).map(IFood::getData).ifPresent(ingredients::add);
        }
        return ingredients;
    }

    @Override
    default public void initFoodStats(CraftingContainer inv, FoodHandler.Dynamic handler) {
        List<FoodData> ingredients = this.gatherIngredients(inv, handler);
        float[] nutrition = this.freshNutrients();
        nutrition = this.nutrients(nutrition);
        float saturation = this.saturation();
        float water = this.water();
        for (FoodData ingredient : ingredients) {
            for (Nutrient nutrient : Nutrient.VALUES) {
                int n = nutrient.ordinal();
                nutrition[n] = nutrition[n] + this.nutrientModifier() * ingredient.nutrient(nutrient);
            }
            saturation += this.nutrientModifier() * ingredient.saturation();
            water += this.nutrientModifier() * ingredient.water();
        }
        handler.setFood(FoodData.create((int)4, (float)water, (float)saturation, (float[])nutrition, (float)this.decay()));
        handler.setCreationDate(FoodCapability.getRoundedCreationDate());
    }

    default public boolean dependsOnInput() {
        return true;
    }

    default public float saturation() {
        return 0.5f;
    }

    default public float water() {
        return 0.0f;
    }

    default public float[] nutrients(float[] input) {
        return input;
    }

    default public float decay() {
        return 1.5f;
    }

    default public float nutrientModifier() {
        return 0.8f;
    }
}

