/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.recipes;

import com.eerussianguy.firmalife.common.blockentities.VatBlockEntity;
import com.eerussianguy.firmalife.common.recipes.FLRecipeSerializers;
import com.eerussianguy.firmalife.common.recipes.FLRecipeTypes;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.common.recipes.ingredients.ItemStackIngredient;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class VatRecipe
implements ISimpleRecipe<VatBlockEntity.VatInventory> {
    private final ResourceLocation id;
    private final ItemStackIngredient inputItem;
    private final FluidStackIngredient inputFluid;
    private final ItemStackProvider outputItem;
    private final FluidStack outputFluid;
    private final int length;
    private final float temperature;
    private final ItemStack jarOutput;

    public VatRecipe(ResourceLocation id, ItemStackIngredient ingredient, FluidStackIngredient fluidInput, ItemStackProvider output, FluidStack outputFluid, int length, float temperature, ItemStack jarOutput) {
        this.id = id;
        this.inputItem = ingredient;
        this.inputFluid = fluidInput;
        this.outputItem = output;
        this.outputFluid = outputFluid;
        this.length = length;
        this.temperature = temperature;
        this.jarOutput = jarOutput;
    }

    public void assembleOutputs(VatBlockEntity.VatInventory inventory) {
        FluidStack outputFluid;
        int remainingItemCount;
        ItemStack outputItem;
        ItemStack stack = Helpers.removeStack((IItemHandler)inventory, (int)0);
        FluidStack fluid = inventory.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        int multiplier = this.inputItem.count() == 0 ? fluid.getAmount() / this.inputFluid.amount() : (this.inputFluid.amount() == 0 ? stack.m_41613_() / this.inputItem.count() : Math.min(fluid.getAmount() / this.inputFluid.amount(), stack.m_41613_() / this.inputItem.count()));
        if (!this.outputFluid.isEmpty()) {
            int capacity = 10000;
            if (this.outputFluid.isFluidEqual(fluid)) {
                capacity -= fluid.getAmount();
            }
            int maxMultiplier = capacity / this.outputFluid.getAmount();
            multiplier = Math.min(multiplier, maxMultiplier);
        }
        if (!(outputItem = this.outputItem.getSingleStack(stack)).m_41619_()) {
            Helpers.consumeInStackSizeIncrements((ItemStack)outputItem, (int)(multiplier * outputItem.m_41613_()), inventory::insertItemWithOverflow);
        }
        if ((remainingItemCount = stack.m_41613_() - multiplier * this.inputItem.count()) > 0) {
            ItemStack remainingStack = stack.m_41777_();
            remainingStack.m_41764_(remainingItemCount);
            inventory.insertItemWithOverflow(remainingStack);
        }
        if ((outputFluid = this.outputFluid.copy()).isEmpty()) {
            int retainAmount = fluid.getAmount() - multiplier * this.inputFluid.amount();
            if (retainAmount > 0) {
                FluidStack retainedFluid = fluid.copy();
                retainedFluid.setAmount(retainAmount);
                inventory.fill(retainedFluid, IFluidHandler.FluidAction.EXECUTE);
            }
        } else {
            int amount = outputFluid.getAmount() * multiplier;
            if (outputFluid.isFluidEqual(fluid)) {
                amount += fluid.getAmount();
            }
            outputFluid.setAmount(Math.min(10000, amount));
            inventory.fill(outputFluid, IFluidHandler.FluidAction.EXECUTE);
        }
        FluidStack current = inventory.getFluidInTank(0);
        if (!current.isEmpty() && !this.jarOutput.m_41619_()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("fruit", (Tag)this.jarOutput.m_41739_(new CompoundTag()));
            current.setTag(tag);
        }
    }

    public boolean matches(VatBlockEntity.VatInventory container, Level level) {
        return this.inputItem.test(container.getStackInSlot(0)) && this.inputFluid.test(container.getFluidInTank(0)) && (this.inputFluid.amount() == 0 || this.outputFluid.getAmount() == 0 || this.inputItem.count() > 0 && this.inputFluid.amount() > 0 && container.getFluidInTank(0).getAmount() / this.inputFluid.amount() <= container.getStackInSlot(0).m_41613_() / this.inputItem.count());
    }

    public ItemStack m_8043_() {
        return this.outputItem.getSingleStack(ItemStack.f_41583_);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FLRecipeSerializers.VAT.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FLRecipeTypes.VAT.get();
    }

    public ItemStackIngredient getInputItem() {
        return this.inputItem;
    }

    public FluidStackIngredient getInputFluid() {
        return this.inputFluid;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public ItemStackProvider getOutputItem() {
        return this.outputItem;
    }

    public int getDuration() {
        return this.length;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public ItemStack getJarOutput() {
        return this.jarOutput;
    }

    public static class Serializer
    extends RecipeSerializerImpl<VatRecipe> {
        public VatRecipe fromJson(ResourceLocation id, JsonObject json) {
            return new VatRecipe(id, json.has("input_item") ? ItemStackIngredient.fromJson((JsonObject)json.getAsJsonObject("input_item")) : ItemStackIngredient.EMPTY, json.has("input_fluid") ? FluidStackIngredient.fromJson((JsonObject)json.getAsJsonObject("input_fluid")) : FluidStackIngredient.EMPTY, json.has("output_item") ? ItemStackProvider.fromJson((JsonObject)json.getAsJsonObject("output_item")) : ItemStackProvider.empty(), json.has("output_fluid") ? JsonHelpers.getFluidStack((JsonObject)json, (String)"output_fluid") : FluidStack.EMPTY, JsonHelpers.m_13824_((JsonObject)json, (String)"length", (int)600), JsonHelpers.m_13820_((JsonObject)json, (String)"temperature", (float)300.0f), json.has("jar") ? JsonHelpers.getItemStack((JsonObject)json, (String)"jar") : ItemStack.f_41583_);
        }

        @Nullable
        public VatRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ItemStackIngredient ingredient = ItemStackIngredient.fromNetwork((FriendlyByteBuf)buffer);
            FluidStackIngredient fluidIngredient = FluidStackIngredient.fromNetwork((FriendlyByteBuf)buffer);
            ItemStackProvider output = ItemStackProvider.fromNetwork((FriendlyByteBuf)buffer);
            FluidStack outputFluid = buffer.readFluidStack();
            int length = buffer.m_130242_();
            float temp = buffer.readFloat();
            ItemStack jar = buffer.m_130267_();
            return new VatRecipe(id, ingredient, fluidIngredient, output, outputFluid, length, temp, jar);
        }

        public void toNetwork(FriendlyByteBuf buffer, VatRecipe recipe) {
            recipe.inputItem.toNetwork(buffer);
            recipe.inputFluid.toNetwork(buffer);
            recipe.outputItem.toNetwork(buffer);
            buffer.writeFluidStack(recipe.outputFluid);
            buffer.m_130130_(recipe.length);
            buffer.writeFloat(recipe.temperature);
            buffer.m_130055_(recipe.jarOutput);
        }
    }
}

