/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.recipes;

import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.common.recipes.FLRecipeSerializers;
import com.google.gson.JsonObject;
import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.capabilities.food.Nutrient;
import net.dries007.tfc.common.items.DynamicBowlFood;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.SoupPotRecipe;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.util.Helpers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;

public class StinkySoupRecipe
extends PotRecipe {
    public static final PotRecipe.OutputType OUTPUT_TYPE = nbt -> {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item"));
        return new StinkOutput(stack);
    };

    public StinkySoupRecipe(ResourceLocation id, List<Ingredient> itemIngredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
        super(id, itemIngredients, fluidIngredient, duration, minTemp);
    }

    public PotRecipe.Output getOutput(PotBlockEntity.PotInventory inventory) {
        int ingredientCount = 0;
        float water = 20.0f;
        float saturation = 2.0f;
        float[] nutrition = new float[Nutrient.TOTAL];
        ItemStack soupStack = ItemStack.f_41583_;
        for (int i = 4; i <= 8; ++i) {
            Nutrient[] stack = inventory.getStackInSlot(i);
            IFood food2 = stack.getCapability(FoodCapability.CAPABILITY).resolve().orElse(null);
            if (food2 == null) continue;
            if (food2.isRotten()) {
                ingredientCount = 0;
                break;
            }
            FoodData data = food2.getData();
            water += data.water();
            saturation += data.saturation();
            for (Nutrient nutrient : Nutrient.VALUES) {
                int n = nutrient.ordinal();
                nutrition[n] = nutrition[n] + data.nutrient(nutrient);
            }
            ++ingredientCount;
        }
        if (ingredientCount > 0) {
            float multiplier = 1.0f - 0.05f * (float)ingredientCount;
            water *= multiplier;
            saturation *= multiplier;
            for (Nutrient nutrient : Nutrient.VALUES) {
                int idx;
                int n = idx = nutrient.ordinal();
                nutrition[n] = nutrition[n] * multiplier;
            }
            FoodData data = FoodData.create((int)4, (float)water, (float)saturation, (float[])nutrition, (float)3.5f);
            int servings = (int)((float)ingredientCount / 2.0f) + 1;
            long created = FoodCapability.getRoundedCreationDate();
            soupStack = new ItemStack((ItemLike)FLItems.STINKY_SOUP.get(), servings);
            soupStack.getCapability(FoodCapability.CAPABILITY).filter(food -> food instanceof DynamicBowlFood.DynamicBowlHandler).ifPresent(food -> {
                DynamicBowlFood.DynamicBowlHandler handler = (DynamicBowlFood.DynamicBowlHandler)food;
                handler.setCreationDate(created);
                handler.setFood(data);
            });
        }
        return new SoupPotRecipe.SoupOutput(soupStack);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FLRecipeSerializers.STINKY_SOUP.get();
    }

    public record StinkOutput(ItemStack stack) implements PotRecipe.Output
    {
        public boolean isEmpty() {
            return this.stack.m_41619_();
        }

        public int getFluidColor() {
            return -10066177;
        }

        public InteractionResult onInteract(PotBlockEntity entity, Player player, ItemStack clickedWith) {
            if (Helpers.isItem((Item)clickedWith.m_41720_(), (TagKey)TFCTags.Items.SOUP_BOWLS) && !this.stack.m_41619_()) {
                this.stack.getCapability(FoodCapability.CAPABILITY).filter(food -> food instanceof DynamicBowlFood.DynamicBowlHandler).ifPresent(food -> ((DynamicBowlFood.DynamicBowlHandler)food).setBowl(clickedWith));
                clickedWith.m_41774_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack.m_41620_(1));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        public void write(CompoundTag nbt) {
            nbt.m_128365_("item", (Tag)this.stack.m_41739_(new CompoundTag()));
        }

        public PotRecipe.OutputType getType() {
            return OUTPUT_TYPE;
        }
    }

    public static class Serializer
    extends PotRecipe.Serializer<StinkySoupRecipe> {
        protected StinkySoupRecipe fromJson(ResourceLocation recipeId, JsonObject json, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            return new StinkySoupRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp);
        }

        protected StinkySoupRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            return new StinkySoupRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp);
        }
    }
}

