/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.recipes;

import com.eerussianguy.firmalife.common.recipes.FLRecipeSerializers;
import com.eerussianguy.firmalife.common.recipes.FLRecipeTypes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class OvenRecipe
implements ISimpleRecipe<ItemStackInventory> {
    public static final IndirectHashCollection<Item, OvenRecipe> CACHE = IndirectHashCollection.createForRecipe(OvenRecipe::getValidItems, FLRecipeTypes.OVEN);
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final ItemStackProvider outputItem;
    private final float temperature;
    private final int duration;

    @Nullable
    public static OvenRecipe getRecipe(ItemStack stack) {
        return OvenRecipe.getRecipe(new ItemStackInventory(stack));
    }

    @Nullable
    public static OvenRecipe getRecipe(ItemStackInventory wrapper) {
        for (OvenRecipe recipe : CACHE.getAll((Object)wrapper.getStack().m_41720_())) {
            if (!recipe.matches(wrapper, null)) continue;
            return recipe;
        }
        return null;
    }

    public OvenRecipe(ResourceLocation id, Ingredient ingredient, ItemStackProvider outputItem, float temperature, int duration) {
        this.id = id;
        this.ingredient = ingredient;
        this.outputItem = outputItem;
        this.temperature = temperature;
        this.duration = duration;
    }

    public boolean matches(ItemStackInventory inventory, @Nullable Level level) {
        return this.getIngredient().test(inventory.getStack());
    }

    public ItemStackProvider getResult() {
        return this.outputItem;
    }

    public int getDuration() {
        return this.duration;
    }

    public ItemStack m_8043_() {
        return this.outputItem.getEmptyStack();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FLRecipeSerializers.OVEN.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FLRecipeTypes.OVEN.get();
    }

    public ItemStack assemble(ItemStackInventory inventory) {
        ItemStack inputStack = inventory.getStack();
        ItemStack outputStack = this.outputItem.getSingleStack(inputStack);
        inputStack.getCapability(HeatCapability.CAPABILITY).ifPresent(oldCap -> outputStack.getCapability(HeatCapability.CAPABILITY).ifPresent(newCap -> newCap.setTemperature(oldCap.getTemperature())));
        return outputStack;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public boolean isValidTemperature(float temperatureIn) {
        return temperatureIn >= this.temperature;
    }

    public Collection<Item> getValidItems() {
        return Arrays.stream(this.getIngredient().m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toSet());
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public static class Serializer
    extends RecipeSerializerImpl<OvenRecipe> {
        public OvenRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            ItemStackProvider outputItem = json.has("result_item") ? ItemStackProvider.fromJson((JsonObject)json.getAsJsonObject("result_item")) : ItemStackProvider.empty();
            float temperature = JsonHelpers.m_13915_((JsonObject)json, (String)"temperature");
            int time = JsonHelpers.m_13927_((JsonObject)json, (String)"duration");
            return new OvenRecipe(recipeId, ingredient, outputItem, temperature, time);
        }

        @Nullable
        public OvenRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStackProvider outputItem = ItemStackProvider.fromNetwork((FriendlyByteBuf)buffer);
            float temperature = buffer.readFloat();
            int duration = buffer.m_130242_();
            return new OvenRecipe(recipeId, ingredient, outputItem, temperature, duration);
        }

        public void toNetwork(FriendlyByteBuf buffer, OvenRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            recipe.outputItem.toNetwork(buffer);
            buffer.writeFloat(recipe.temperature);
            buffer.m_130130_(recipe.duration);
        }
    }
}

