/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.DryingMatBlock;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.FirepitBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StringBlock
extends DeviceBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    private static final VoxelShape SHAPE_X = StringBlock.m_49796_((double)0.0, (double)8.0, (double)7.0, (double)16.0, (double)10.0, (double)9.0);
    private static final VoxelShape SHAPE_Z = StringBlock.m_49796_((double)7.0, (double)8.0, (double)0.0, (double)9.0, (double)10.0, (double)16.0);
    private final Supplier<? extends Item> item;

    @Nullable
    public static FirepitBlockEntity findFirepit(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)pos);
        int range = (Integer)FLConfig.SERVER.smokingFirepitRange.get();
        for (int i = 0; i < range; ++i) {
            FirepitBlockEntity firepit;
            mutable.m_122184_(0, -1, 0);
            BlockState stateAt = level.m_8055_((BlockPos)mutable);
            if (stateAt.m_60795_() || stateAt.m_60734_() instanceof StringBlock) continue;
            BlockEntity blockEntity = level.m_7702_((BlockPos)mutable);
            return blockEntity instanceof FirepitBlockEntity ? (firepit = (FirepitBlockEntity)blockEntity) : null;
        }
        return null;
    }

    public StringBlock(ExtendedProperties properties, Supplier<? extends Item> item) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.item = item;
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        level.m_141902_(pos, (BlockEntityType)FLBlockEntities.STRING.get()).ifPresent(string -> {
            ItemStack stack = string.readStack();
            if (!stack.m_41619_()) {
                stack.getCapability(FoodCapability.CAPABILITY).ifPresent(food -> {
                    List traits = food.getTraits();
                    if (traits.contains(FLFoodTraits.SMOKED) || traits.contains(FLFoodTraits.RANCID_SMOKED)) {
                        double x = (double)pos.m_123341_() + 0.5;
                        double y = (double)pos.m_123342_() + 0.55;
                        double z = (double)pos.m_123343_() + 0.5;
                        for (int i = 0; i < 4; ++i) {
                            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, (double)(Helpers.triangle((Random)random) / 10.0f), (double)(random.nextFloat() / 5.0f), (double)(Helpers.triangle((Random)random) / 10.0f));
                        }
                    }
                });
            }
        });
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        return this.canSurvive(level, pos, state) ? super.m_7417_(state, facing, facingState, level, pos, facingPos) : Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = null;
        Direction.Axis axis = context.m_43719_().m_122434_();
        if (axis.m_122479_()) {
            state = (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)axis);
        } else {
            Player player = context.m_43723_();
            if (player != null && (axis = player.m_6350_().m_122434_()).m_122479_()) {
                state = (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)axis);
            }
        }
        if (state != null && this.canSurvive((LevelAccessor)context.m_43725_(), context.m_8083_(), state)) {
            return state;
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return state.m_61143_(AXIS) == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getItem();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return DryingMatBlock.use(level, pos, player, hand);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)this.item.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{AXIS}));
    }

    private boolean canSurvive(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if (d.m_122434_() != axis) continue;
            mutable.m_122190_((Vec3i)pos);
            for (int i = 0; i < 5; ++i) {
                mutable.m_122173_(d);
                BlockState stateAt = level.m_8055_((BlockPos)mutable);
                if (stateAt.m_60734_() instanceof StringBlock || !stateAt.m_60783_((BlockGetter)level, (BlockPos)mutable, d.m_122424_())) continue;
                return true;
            }
        }
        return false;
    }
}

