/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.blockentities.StovetopPotBlockEntity;
import java.util.Random;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StovetopPotBlock
extends BottomSupportedDeviceBlock {
    public static final VoxelShape SHAPE = StovetopPotBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);

    public StovetopPotBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP, SHAPE);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StovetopPotBlockEntity) {
            StovetopPotBlockEntity pot = (StovetopPotBlockEntity)blockEntity;
            if (!pot.isBoiling()) {
                return;
            }
            double x = (double)pos.m_123341_() + 0.5;
            double y = (float)pos.m_123342_() + 0.1875f;
            double z = (double)pos.m_123343_() + 0.5;
            for (int i = 0; i < rand.nextInt(5) + 4; ++i) {
                level.m_6493_((ParticleOptions)TFCParticles.BUBBLE.get(), false, x + (double)rand.nextFloat() * 0.375 - 0.1875, y, z + (double)rand.nextFloat() * 0.375 - 0.1875, 0.0, 0.05, 0.0);
            }
            level.m_6493_((ParticleOptions)TFCParticles.STEAM.get(), false, x, y + 0.8, z, (double)Helpers.triangle((Random)rand), 0.5, (double)Helpers.triangle((Random)rand));
            level.m_7785_(x, y, z, SoundEvents.f_12540_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.7f + 0.4f, false);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StovetopPotBlockEntity) {
            StovetopPotBlockEntity pot = (StovetopPotBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (!pot.isBoiling() && FluidHelpers.transferBetweenBlockEntityAndItem((ItemStack)stack, (BlockEntity)pot, (Player)player, (InteractionHand)hand)) {
                pot.markForSync();
            } else {
                InteractionResult interactResult;
                if (!pot.isBoiling() && (interactResult = pot.interactWithOutput(player, stack)) != InteractionResult.PASS) {
                    return interactResult;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Helpers.openScreen((ServerPlayer)serverPlayer, (MenuProvider)pot, (BlockPos)pos);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }
}

