/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.ClimateReceiver;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.greenhouse.SquirtingMoistureTransducerBlock;
import java.util.Random;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class SquirtingMoistureTransducerBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements ClimateReceiver {
    private static final int WATER_UPDATE_INTERVAL = 1200;
    private boolean climateValid = false;
    private int cachedMoisture = -1;

    public static void serverTick(Level level, BlockPos pos, BlockState state, SquirtingMoistureTransducerBlockEntity transducer) {
        transducer.checkForLastTickSync();
        if (level.m_46467_() % 20L == 0L || transducer.cachedMoisture == -1) {
            transducer.cachedMoisture = SquirtingMoistureTransducerBlockEntity.updateMoisture(level, pos, state, transducer);
        }
        if (transducer.climateValid && level.m_46467_() % 1200L == 0L && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (SquirtingMoistureTransducerBlockEntity.updateMoisture(level, pos, state, transducer) > SquirtingMoistureTransducerBlockEntity.getMinPipes(level, pos)) {
                double x = (double)pos.m_123341_() + 0.5;
                double y = (double)pos.m_123342_() + 1.1;
                double z = (double)pos.m_123343_() + 0.5;
                Random random = level.f_46441_;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x + (double)Helpers.triangle((Random)random, (int)2), y + (double)Helpers.triangle((Random)random, (int)2) + 2.0, z + (double)Helpers.triangle((Random)random, (int)2), 15, 0.0, 0.0, 0.0, 1.0);
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.STEAM.get()), x, y, z, 15, 0.0, 0.0, 0.0, 1.0);
                FLHelpers.allPositionsCentered(pos, 4, 4).forEach(checkPos -> {
                    ClimateReceiver receiver = ClimateReceiver.get(level, pos);
                    if (receiver != null) {
                        receiver.addWater(0.1f);
                    }
                });
                Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11914_);
            }
        }
    }

    public static int getMinPipes(Level level, BlockPos pos) {
        return Mth.m_14143_((float)Mth.m_184637_((float)Climate.getRainfall((Level)level, (BlockPos)pos), (float)0.0f, (float)500.0f, (float)31.0f, (float)13.0f));
    }

    private static int updateMoisture(Level level, BlockPos pos, BlockState state, SquirtingMoistureTransducerBlockEntity transducer) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Block pipe = (Block)FLBlocks.EMBEDDED_PIPE.get();
        BlockState pipeState = pipe.m_49966_();
        return transducer.getCapability(Capabilities.ITEM).map(inv -> {
            int found = 0;
            for (int y = -1; y >= -32; --y) {
                mutable.m_122154_((Vec3i)pos, 0, y, 0);
                BlockState stateAt = level.m_8055_((BlockPos)mutable);
                if (!Helpers.isBlock((BlockState)stateAt, (Block)pipe)) {
                    if (!level.f_46443_) {
                        ItemStack stack = inv.getStackInSlot(0);
                        if (stack.m_41619_() || !Helpers.isBlock((BlockState)stateAt, FLTags.Blocks.PIPE_REPLACEABLE) && !stateAt.m_60795_()) continue;
                        ++found;
                        level.m_46597_((BlockPos)mutable, pipeState);
                        inv.extractItem(0, 1, false);
                        transducer.markForSync();
                        Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_12065_);
                        return found;
                    }
                    return found;
                }
                ++found;
            }
            return found;
        }).orElse(0);
    }

    public SquirtingMoistureTransducerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.SQUIRTING_MOISTURE_TRANSDUCER.get(), pos, state, SquirtingMoistureTransducerBlockEntity.defaultInventory((int)1), FLHelpers.blockEntityName("squirting_moisture_transducer"));
    }

    public boolean isClimateValid() {
        return this.climateValid;
    }

    public int getCachedMoisture() {
        assert (this.f_58857_ != null);
        if (this.cachedMoisture == -1 || this.f_58857_.m_46467_() % 20L == 0L) {
            this.cachedMoisture = SquirtingMoistureTransducerBlockEntity.updateMoisture(this.f_58857_, this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), this);
        }
        return this.cachedMoisture;
    }

    public int getSlotStackLimit(int slot) {
        return 32;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.m_41720_() == ((Block)FLBlocks.EMBEDDED_PIPE.get()).m_5456_();
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.climateValid = nbt.m_128471_("valid");
        this.cachedMoisture = -1;
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("valid", this.climateValid);
    }

    @Override
    public void setValid(Level level, BlockPos pos, boolean valid, int tier, boolean cellar) {
        if (!cellar) {
            boolean stasis;
            this.climateValid = valid;
            this.markForSync();
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() instanceof SquirtingMoistureTransducerBlock && (stasis = ((Boolean)state.m_61143_((Property)SquirtingMoistureTransducerBlock.STASIS)).booleanValue()) != valid) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SquirtingMoistureTransducerBlock.STASIS, (Comparable)Boolean.valueOf(valid)));
            }
        }
    }
}

