/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.blockentities.ClimateReceiver;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.greenhouse.SprinklerBlock;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.capabilities.InventoryFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SprinklerBlockEntity
extends TFCBlockEntity
implements FluidTankCallback,
ClimateReceiver {
    public static final int TANK_CAPACITY = 1000;
    private FluidTank tank;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private boolean valid = false;

    public static void serverTick(Level level, BlockPos pos, BlockState state, SprinklerBlockEntity sprinkler) {
        if (level.m_46467_() % 20L == 0L && sprinkler.valid) {
            Block block;
            BlockEntity above;
            if (sprinkler.tank.getFluidInTank(0).getAmount() < 1000 && (above = level.m_7702_(pos.m_7494_())) != null) {
                above.getCapability(Capabilities.FLUID, Direction.DOWN).ifPresent(aboveCap -> {
                    int amount = 1000 - sprinkler.tank.getFluidInTank(0).getAmount();
                    if (amount > 0) {
                        sprinkler.tank.fill(aboveCap.drain(amount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                });
            }
            if (level.m_46467_() % 40L == 0L && (block = state.m_60734_()) instanceof SprinklerBlock) {
                SprinklerBlock block2 = (SprinklerBlock)block;
                sprinkler.getCapability(Capabilities.FLUID, Direction.UP).ifPresent(cap -> {
                    for (BlockPos testPos : block2.getPathMaker().apply(pos)) {
                        ClimateReceiver receiver = ClimateReceiver.get(level, testPos);
                        if (receiver == null || cap.getFluidInTank(0).getAmount() <= 10 || !receiver.addWater(0.1f)) continue;
                        cap.drain(10, IFluidHandler.FluidAction.EXECUTE);
                    }
                });
            }
        }
    }

    public SprinklerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FLBlockEntities.SPRINKLER.get(), pos, state);
    }

    public SprinklerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = new InventoryFluidTank(1000, f -> Fluids.f_76193_.m_5613_().m_6212_(f.getFluid()), (FluidTankCallback)this);
    }

    public boolean isActive() {
        return this.valid && this.tank.getFluidInTank(0).getAmount() > 0;
    }

    public void fluidTankChanged() {
        this.markForSync();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if ((side == Direction.UP || side == null) && cap == Capabilities.FLUID) {
            return this.holder.cast();
        }
        return super.getCapability(cap, side);
    }

    public void loadAdditional(CompoundTag tag) {
        this.tank.readFromNBT(tag.m_128469_("tank"));
        this.valid = tag.m_128471_("valid");
        super.loadAdditional(tag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        tag.m_128379_("valid", this.valid);
        super.m_183515_(tag);
    }

    @Override
    public void setValid(Level level, BlockPos pos, boolean valid, int tier, boolean cellar) {
        if (valid != this.valid) {
            this.markForSync();
        }
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }
}

