/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemStackHandler;

public class PlateBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    private float rot = 0.0f;

    public PlateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.PLATE.get(), pos, state, PlateBlockEntity.defaultInventory((int)1), FLHelpers.blockEntityName("plate"));
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).insert(new int[]{0}), (Predicate)Direction.Plane.HORIZONTAL).on((Object)new PartialItemHandler(this.inventory).extract(new int[]{0}), new Direction[]{Direction.DOWN});
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.rot = nbt.m_128457_("rot");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128350_("rot", this.rot);
    }

    public void setRotation(Player player) {
        this.rot = player.m_146908_();
        this.markForSync();
    }

    public float getRotation() {
        return this.rot;
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.getCapability((ICapabilityProvider)stack, (Capability)FoodCapability.CAPABILITY) != null;
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
    }

    public ItemStack viewStack() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0);
    }
}

