/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.IceFishingStationBlock;
import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.items.TFCFishingRodItem;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class IceFishingStationBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    @Nullable
    private AbstractFish hooked = null;
    private int entityId = -1;

    public static void serverTick(Level level, BlockPos pos, BlockState state, IceFishingStationBlockEntity station) {
        station.checkForLastTickSync();
        if (level.m_46467_() % 40L == 0L && state.m_60734_() instanceof IceFishingStationBlock) {
            ItemStack bait = TFCFishingRodItem.getBaitItem((ItemStack)station.getRod());
            TFCFishingRodItem.BaitType type = TFCFishingRodItem.getBaitType((ItemStack)bait);
            if (((Boolean)state.m_61143_((Property)IceFishingStationBlock.CAST)).booleanValue()) {
                if (type != TFCFishingRodItem.BaitType.SMALL) {
                    station.withdraw();
                    return;
                }
                if (station.hooked == null) {
                    for (AbstractFish fish : level.m_45976_(AbstractFish.class, new AABB(station.getBaitPos(state)).m_82400_(3.0))) {
                        if (Helpers.isEntity((Entity)fish, (TagKey)TFCTags.Entities.NEEDS_LARGE_FISHING_BAIT)) continue;
                        station.hooked = fish;
                        station.markForSync();
                        break;
                    }
                }
            }
        }
        if (station.hooked != null) {
            if (station.hooked.m_146910_() || station.hooked.m_21224_()) {
                station.hooked = null;
                station.markForSync();
            } else {
                station.hooked.m_21446_(station.getBaitPos(state), 3);
                if (level.m_46467_() % 30L == 0L) {
                    station.hooked.m_21573_().m_26519_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.0);
                }
                if (level.f_46441_.nextFloat() < 0.05f && level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    Random random = level.f_46441_;
                    BlockPos particlePos = pos.m_142300_((Direction)state.m_61143_((Property)IceFishingStationBlock.FACING));
                    Helpers.playSound((Level)level, (BlockPos)particlePos, (SoundEvent)SoundEvents.f_11940_);
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123769_, (double)((float)particlePos.m_123341_() + random.nextFloat()), (double)((float)particlePos.m_123342_() + random.nextFloat() * 0.1f), (double)((float)particlePos.m_123343_() + random.nextFloat()), 3, 0.0, 0.0, 0.0, 1.0);
                }
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, IceFishingStationBlockEntity station) {
        if (station.hooked == null) {
            if (station.entityId != -1) {
                Entity entity = level.m_6815_(station.entityId);
                if (entity instanceof AbstractFish) {
                    AbstractFish fish;
                    station.hooked = fish = (AbstractFish)entity;
                }
                station.entityId = -1;
            }
        } else if (station.hooked.m_146910_() || station.hooked.m_21224_()) {
            station.hooked = null;
        }
    }

    public IceFishingStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.ICE_FISHING_STATION.get(), pos, state, IceFishingStationBlockEntity.defaultInventory((int)1), FLHelpers.blockEntityName("ice_fishing_station"));
    }

    public void withdraw() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)IceFishingStationBlock.CAST, (Comparable)Boolean.valueOf(false)));
        this.hooked = null;
        this.markForSync();
    }

    public boolean hasHooked() {
        return this.hooked != null;
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        if (nbt.m_128425_("entityId", 3)) {
            this.entityId = nbt.m_128451_("entityId");
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.hooked != null) {
            nbt.m_128405_("entityId", this.hooked.m_142049_());
        }
    }

    @Nullable
    public AbstractFish getHooked() {
        return this.hooked;
    }

    public void pullHooked() {
        if (this.hooked != null) {
            BlockPos pullPos = this.f_58858_.m_142300_((Direction)this.m_58900_().m_61143_((Property)IceFishingStationBlock.FACING));
            this.hooked.m_6021_((double)pullPos.m_123341_() + 0.5, (double)pullPos.m_123342_() + 0.5, (double)pullPos.m_123343_() + 0.5);
            this.hooked.m_6074_();
            this.markForSync();
        }
    }

    public boolean hasBait() {
        return TFCFishingRodItem.getBaitType((ItemStack)TFCFishingRodItem.getBaitItem((ItemStack)this.getRod())) == TFCFishingRodItem.BaitType.SMALL;
    }

    public ItemStack getRod() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0);
    }

    public BlockPos getBaitPos(BlockState state) {
        return this.f_58858_.m_142300_((Direction)state.m_61143_((Property)IceFishingStationBlock.FACING)).m_6625_(5);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.m_41720_() instanceof TFCFishingRodItem;
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }
}

