/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.render;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.IceFishingStationBlockEntity;
import com.eerussianguy.firmalife.common.blocks.IceFishingStationBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class IceFishingStationBlockEntityRenderer
implements BlockEntityRenderer<IceFishingStationBlockEntity> {
    private static final float RED = 0.1f;
    private static final float GREEN = 0.07f;
    private static final float BLUE = 0.02f;

    public void render(IceFishingStationBlockEntity station, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        ItemStack rod = station.getRod();
        BlockState state = station.m_58900_();
        if (!rod.m_41619_() && state.m_60734_() instanceof IceFishingStationBlock && station.m_58904_() != null) {
            Direction facing = (Direction)state.m_61143_((Property)IceFishingStationBlock.FACING);
            int angle = 90 + (switch (facing) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.SOUTH -> 0;
                case Direction.EAST -> 90;
                case Direction.WEST, Direction.DOWN, Direction.UP -> 270;
                case Direction.NORTH -> 180;
            });
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.4, 0.5);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)angle));
            poseStack.m_85841_(1.2f, 1.2f, 1.2f);
            Minecraft.m_91087_().m_91291_().m_174269_(rod, ItemTransforms.TransformType.FIXED, combinedLight, combinedOverlay, poseStack, buffers, 0);
            poseStack.m_85849_();
            if (((Boolean)state.m_61143_((Property)IceFishingStationBlock.CAST)).booleanValue()) {
                this.renderFishingLine(station, station.getHooked(), partialTicks, poseStack, buffers, facing);
            }
        }
    }

    private void renderFishingLine(IceFishingStationBlockEntity station, @Nullable AbstractFish fish, float partialTick, PoseStack poseStack, MultiBufferSource buffers, Direction dir) {
        float dz;
        float dy;
        float dx;
        poseStack.m_85836_();
        BlockPos hookPos = station.m_58899_();
        Vec3 ropePos = FLHelpers.vec3(hookPos).m_82520_(0.5, 1.8, 0.5).m_82520_((double)(dir.m_122429_() * 2), 0.0, (double)(dir.m_122431_() * 2));
        poseStack.m_85837_(ropePos.f_82479_, ropePos.f_82480_, ropePos.f_82481_);
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_173247_());
        PoseStack.Pose pose = poseStack.m_85850_();
        if (fish != null) {
            Vec3 off = fish.m_7939_();
            dx = (float)(fish.f_19854_ - ropePos.f_82479_ + off.f_82479_);
            dy = (float)(fish.f_19855_ - ropePos.f_82480_ + off.f_82480_);
            dz = (float)(fish.f_19856_ - ropePos.f_82481_ + off.f_82481_);
        } else {
            BlockPos lowerPos = station.getBaitPos(station.m_58900_());
            dx = (float)((double)((float)lowerPos.m_123341_() + 0.5f) - ropePos.f_82479_);
            dy = (float)((double)((float)lowerPos.m_123342_() + 0.5f) - ropePos.f_82480_);
            dz = (float)((double)((float)lowerPos.m_123343_() + 0.5f) - ropePos.f_82481_);
        }
        for (int k = 0; k <= 16; ++k) {
            IceFishingStationBlockEntityRenderer.stringVertex(dx, dy, dz, buffer, pose, IceFishingStationBlockEntityRenderer.fraction(k, 16), IceFishingStationBlockEntityRenderer.fraction(k + 1, 16));
        }
        poseStack.m_85849_();
    }

    private static float fraction(int num, int denominator) {
        return (float)num / (float)denominator;
    }

    private static void stringVertex(float dx, float dy, float dz, VertexConsumer buffer, PoseStack.Pose poseStack, float v1, float v2) {
        float x = dx * v1;
        float y = dy * (v1 * v1 + v1) * 0.5f + 0.25f;
        float z = dz * v1;
        float n1 = dx * v2 - x;
        float n2 = dy * (v2 * v2 + v2) * 0.5f + 0.25f - y;
        float n3 = dz * v2 - z;
        float size = Mth.m_14116_((float)(n1 * n1 + n2 * n2 + n3 * n3));
        buffer.m_85982_(poseStack.m_85861_(), x, y, z).m_6122_(0, 0, 0, 255).m_85977_(poseStack.m_85864_(), n1 /= size, n2 /= size, n3 /= size).m_5752_();
    }
}

