/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import java.util.Date;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class UpdateForceLoadExpiryPacket
extends BaseC2SMessage {
    private final ChunkDimPos pos;
    private final long relativeExpiryTime;

    public UpdateForceLoadExpiryPacket(ChunkDimPos pos, Date expiryDate) {
        this.pos = pos;
        this.relativeExpiryTime = expiryDate == null ? 0L : Math.max(0L, expiryDate.getTime() - System.currentTimeMillis());
    }

    public UpdateForceLoadExpiryPacket(FriendlyByteBuf buf) {
        this.pos = new ChunkDimPos(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_()), buf.readInt(), buf.readInt());
        this.relativeExpiryTime = buf.readLong();
    }

    public MessageType getType() {
        return FTBChunksNet.UPDATE_FORCE_LOAD_EXPIRY;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.pos.dimension.m_135782_());
        buf.writeInt(this.pos.x);
        buf.writeInt(this.pos.z);
        buf.writeLong(this.relativeExpiryTime);
    }

    public void handle(NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ClaimedChunk chunk;
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.f_19853_.m_46472_().equals(this.pos.dimension) && (chunk = FTBChunksAPI.getManager().getChunk(this.pos)) != null && chunk.teamData.getTeam().isMember(sp.m_142081_()) && chunk.isForceLoaded()) {
                chunk.setForceLoadExpiryTime(this.relativeExpiryTime == 0L ? 0L : System.currentTimeMillis() + this.relativeExpiryTime);
                SendChunkPacket packet = new SendChunkPacket((ResourceKey<Level>)this.pos.dimension, chunk.teamData.getTeamId(), new SendChunkPacket.SingleChunk(System.currentTimeMillis(), chunk.pos.x, chunk.pos.z, chunk));
                packet.sendTo(sp);
            }
        }
    }
}

