/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map.color;

import com.mojang.blaze3d.platform.NativeImage;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ColorUtils {
    public static Color4I[] reducedColorPalette = null;
    public static Color4I[] topographyPalette = null;
    public static Color4I[][] lightMapPalette = null;
    private static final HashMap<Color4I, Color4I> reducedColorMap = new HashMap();

    public static int convertToNative(int c) {
        return NativeImage.m_84992_((int)(c >> 24 & 0xFF), (int)(c >> 0 & 0xFF), (int)(c >> 8 & 0xFF), (int)(c >> 16 & 0xFF));
    }

    public static int convertFromNative(int c) {
        return NativeImage.m_84983_((int)c) << 24 | NativeImage.m_85085_((int)c) << 16 | NativeImage.m_85103_((int)c) << 8 | NativeImage.m_85119_((int)c);
    }

    public static Color4I addBrightness(Color4I c, float f) {
        float r = c.redf() + f;
        float g = c.greenf() + f;
        float b = c.bluef() + f;
        int ri = Mth.m_14045_((int)((int)(r * 255.0f)), (int)0, (int)255);
        int gi = Mth.m_14045_((int)((int)(g * 255.0f)), (int)0, (int)255);
        int bi = Mth.m_14045_((int)((int)(b * 255.0f)), (int)0, (int)255);
        return Color4I.rgb((int)ri, (int)gi, (int)bi);
    }

    public static Color4I reduce(Color4I c) {
        if (reducedColorPalette == null) {
            reducedColorPalette = new Color4I[0];
            try (InputStream stream = Minecraft.m_91087_().m_91098_().m_142591_(new ResourceLocation("ftbchunks:textures/reduced_color_palette.png")).m_6679_();){
                NativeImage image = NativeImage.m_85058_((InputStream)stream);
                int w = image.m_84982_();
                int h = image.m_85084_();
                reducedColorPalette = new Color4I[w * h];
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int col2 = image.m_84985_(x, y);
                        ColorUtils.reducedColorPalette[x + y * w] = Color4I.rgb((int)(NativeImage.m_85085_((int)col2) << 16 | NativeImage.m_85103_((int)col2) << 8 | NativeImage.m_85119_((int)col2)));
                    }
                }
                image.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (reducedColorPalette.length == 0) {
            return c;
        }
        return reducedColorMap.computeIfAbsent(c, col -> {
            int r = col.redi();
            int g = col.greeni();
            int b = col.bluei();
            long prevDist = Long.MAX_VALUE;
            Color4I colr = Color4I.BLACK;
            for (Color4I rcol : reducedColorPalette) {
                long db;
                long dg;
                long dr = r - rcol.redi();
                long d = dr * dr + (dg = (long)(g - rcol.greeni())) * dg + (db = (long)(b - rcol.bluei())) * db;
                if (d >= prevDist) continue;
                prevDist = d;
                colr = rcol;
            }
            return colr;
        });
    }

    public static Color4I[] getTopographyPalette() {
        if (topographyPalette == null) {
            topographyPalette = new Color4I[0];
            try (InputStream stream = Minecraft.m_91087_().m_91098_().m_142591_(new ResourceLocation("ftbchunks:textures/topography_palette.png")).m_6679_();){
                NativeImage image = NativeImage.m_85058_((InputStream)stream);
                int w = image.m_84982_();
                int h = image.m_85084_();
                topographyPalette = new Color4I[w * h];
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int col = image.m_84985_(x, y);
                        ColorUtils.topographyPalette[x + y * w] = Color4I.rgb((int)ColorUtils.convertFromNative(col)).withAlpha(255);
                    }
                }
                image.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return topographyPalette;
    }

    public static Color4I[][] getLightMapPalette() {
        if (lightMapPalette == null) {
            lightMapPalette = new Color4I[0][0];
            try (InputStream stream = Minecraft.m_91087_().m_91098_().m_142591_(new ResourceLocation("ftbchunks:textures/lightmap_palette.png")).m_6679_();){
                NativeImage image = NativeImage.m_85058_((InputStream)stream);
                int w = image.m_84982_();
                int h = image.m_85084_();
                lightMapPalette = new Color4I[w][h];
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int col = image.m_84985_(x, y);
                        ColorUtils.lightMapPalette[x][y] = Color4I.rgb((int)ColorUtils.convertFromNative(col)).withAlpha(255);
                    }
                }
                image.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lightMapPalette;
    }
}

